;*************This is CFdriver.inc ********************************
;
; File Name		:"CFdriver.inc"
; Title			: Definitions of ports, registers and pins
; Date			: 27-01-2001
; Version		: 1.3
; Author		: Loek Gijben
; Contact               : L.H.Gijben@Flatnet.TUDelft.nl
;
; Compact-Flash driver for AVR include file for definitions.
;***************************************************************

;****** CF-driver definitions **********************
.def CF_Rd_LowR = r0
.def CF_Rd_HighR = r1
.def CF_Wr_LowR = r0
.def CF_Wr_HighR = r1
.def tempCF1 = r18
.def tempCF2 = r19
.def tempCF3 = r20
.def ATAdata = r21
.def ATAaddress = r22

;****** Port naming definitions ********************************
.equ ATAdataPort	=$1b	; Databus on PortA
.equ ATAdataINPort	=$19	; Databus input (PINA)
.equ ATAdatadir		=$1a	; Datadirection register (also PortA)
.equ ATAaddressPort	=$03	; ATAaddress (+ -CE/-Wr/-Rd and RDY/BSY) on PortE
.equ CF_RDYBSYPort	=$01	; PINE

;****** ATAaddress Port definitions ****************************
.equ CF_RDYBSY 		= 4	; Compact-Flash RDY/BSY signal pin number
.equ CF_notRd  		= 5	; -OE pin number
.equ CF_notWr  		= 6	; -WE pin number
.equ CF_notCE  		= 7	; Compact-Flash Chip Enable signal

;*** predefined values of ATAaddress****************************
.equ CF_Rd_High		= $60	; ATA data register addressed, RDY/BSY=Pull-up, 
				; -Rd and -Wd =high, -CE = low
.equ CF_Rd_Low		= $40	; .. the same except -Rd = low
.equ CF_Wr_High		= $60	; Same as CF_Rd_High, makes for readable code
.equ CF_Wr_Low		= $20	; .. now -Wr is low.
.equ CF_CMD_High	= $67	; Selects command register, -Wr/-Rd high, -CE low
.equ CF_CMD_Low		= $27	; .. now with -WR low 
.equ CF_Off		= $E0	; Off position (-CE,-Rd, and -Wr high)
.equ CF_DevCont		= $6E	; Select Device Control register

;*** predefined values of ATA commands *************************
.equ CF_Reset		= $0E	; Execute soft reset (in Device Control register)
.equ CF_Resume		= $0A   ; Resume from a soft reset( i.e. release reset button)
.equ CF_Format		= $50	; Relates to format sector(s) in LBA mode
.equ CF_ID_DRV		= $EC	; Identify drive
.equ CF_Sleep		= $E0	; Standby immediate	
.equ CF_RD_Sectors	= $20	; Read sector(s)
.equ CF_WR_Sectors	= $30	; Write sector(s) 

;*** predefined values of MCUCR register ***********************
; These values are used to switch on/off external memory interface
; with a single OUT instruction (one clock cycle)
.equ XSRAMon		= $80	; For waitstate set value to $C0
.equ XSRAMoff		= $00	;
