;***************************************************************************
; 
; File Name		:'Watchdog.asm"
; Title			:
; Date			:
; Version		:
; Support telephone	:765 287 1987  David B. VanHorn
; Support fax		:765 287 1989
; Support Email		:dvanhorn@cedar.net
; Target MCU		:AT90S8515
; 
;***************************************************************************;
;	M O D I F I C A T I O N   H I S T O R Y 
;
;
;       rev.      date    who   why
;	----	--------  ---	------------------------------------------
;	0.01	98.07.29  dvh	Creation
;	0.02	00.10.08  dvh	Added pushpop of temp in timed_smack
;				so that routines that use temp can call 
;				this routine.
;
;********************************************************************
;
;Make sure that the timeout selected here is more than 1mS larger than 
;the value selected for Dog_Food in EQUATES.INC
;Dog_Food = 255, timer= 256 seems to work.but beware.
;The timer as implemented could be as much as 1mS off, since events
;can begin just after a reload.
;
.DSEG
Dog_Food:	.byte	1	;A place to store dog food
.CSEG
.equ		Dog_Chow = 251	;How many mS between feedings.


Init_Watchdog:
	ldi	TEMP,$0F		;000XXXXX Reserved
					;XXX0XXXX Watchdog turnoff enable
					;XXXX1XXX Watchdog enable bit 1=enable
					;XXXXX000 (8) Watchdog timeout,  16mS
					;XXXXX001 (9) Watchdog timeout.  32mS
					;XXXXX010 (A) Watchdog timeout.  64mS
					;XXXXX011 (B) Watchdog timeout. 128mS
					;XXXXX100 (C) Watchdog timeout, 256mS
					;XXXXX101 (D) Watchdog timeout, 512mS
					;XXXXX110 (E) Watchdog timeout,1024mS
					;XXXXX111 (F) Watchdog timeout,2048mS
	out	WDTCR,TEMP		;

;Initial states for watchdog timer
;
	ldi	TEMP,Dog_Chow		;Start a countdown for resetting the watchdog
	sts	Dog_Food,TEMP		;

	ret				;
;
;********************************************************************
;
Timed_Smack:

	;Whatever you need to satisfy the internal or external watchdog

	;The internal watchdog can be set to 16,32,64,128,256,512,1024,or 2048mS
	;This scheme for timed reset is limited to 255mS between resets, but it can
	;be used with any of the timeouts above. Resetting a watchdog more frequently
	;than is needed, is mostly harmless.
	;Just make sure that the value you set the timer to at the end of INIT is
	;GREATER than the value you assign for Dog_Chow in EQUATES.INC
	;The code to set the watchdog to a particular interval is in INIT.ASM
	push	TEMP			;Some routines that need to use this,
					;also need to use TEMP..
	lds	TEMP,Dog_Food		;How many milliseconds before reset is needed?
	and	TEMP,TEMP		;Is it zero?
	brne	Smack_Done		;Nope, just exit

	ldi	TEMP,Dog_Chow		;Reload the timer for the next occurence
	sts	Dog_Food,TEMP		;

	wdr	;This code will reset the internal watchdog

	ldi	TEMP,$0D		;000XXXXX Reserved
					;XXX0XXXX Watchdog turnoff enable
					;XXXX1XXX Watchdog enable bit 1=enable
					;XXXXX000 (8) Watchdog timeout,  16mS
					;XXXXX001 (9) Watchdog timeout.  32mS
					;XXXXX010 (A) Watchdog timeout.  64mS
					;XXXXX011 (B) Watchdog timeout. 128mS
					;XXXXX100 (C) Watchdog timeout, 256mS
					;XXXXX101 (D) Watchdog timeout, 512mS
					;XXXXX110 (E) Watchdog timeout,1024mS
					;XXXXX111 (F) Watchdog timeout,2048mS
	out	WDTCR,TEMP		;

Smack_Done:
	pop	TEMP			;
	ret

