;***************************************************************************
; 
; File Name		:"TABLES.asm"
; Title			:Constant data
; Date			:98.07.21
; Version		:0.01
; Support telephone	:765 287 1987  David B. VanHorn
; Support fax		:765 287 1989
; Support Email		:dvanhorn@cedar.net
; Target MCU		:AT90S8515
;
;***************************************************************************;
;	M O D I F I C A T I O N   H I S T O R Y 
;
;       rev.      date    who   why
;	----	--------  ---	------------------------------------------
;	0.01	98.07.29  dvh	Creation
;	0.02	98.09.27  dvh	Added servo min and range tables for fast servo math
;	0.03	00.10.01  dvh	Exported tables back to their routines.
;				it's clearer that way. 
;				This file now is just a simple example of how tables
;				work in the AVR, and not part of the main app
;
;
;*************************************************************************
;The provided example could be implemented as an algorithm, simply adding 
;30h to the input byte, but in the table implementation, any value can be 
;used. This is good for functions where the translation algorithm is unknown
;or arbitrary. Mainly I wanted a clear example of table based translation.
;*************************************************************************
;
;.org $F00	;Arbitrary point in romspace
		;Optionally, comment out the .org directive, and
		;the table will float at the end of the code
		;provided it is the LAST FILE included in MAIN
		;
		;Nothing prevents you from splattering your tables
		;throughout the rom space, but it's neater this way :)
.cseg
;
;*************************************************************************
;
;Just an example table for now.
;
; Obviously a table is not the most efficient way to do this function,
; but I wanted something small and simple. If I was going to do this for 
; real, I'd just add 30h to the binary value.  Point being though, that
; tables can be used to translate one value into another, where the output
; value might be very time consuming to calculate, or there might not be
; an algorithmic relationship at all.
;
; Using a binary value as an offset into the table, we read the ascii 
; value.  Base address + 06h points to 36h, which is an ascii "6".
;
;
BIN2ASC_TAB:
;	 0   1   2   3   4   5   6   7   8   9   A   B   C   D   E   F
.db	$30,$31,$32,$33,$34,$35,$36,$37,$38,$39,$41,$42,$43,$44,$45,$46
;
;*************************************************************************
;
;Example table-reading code. Converts a binary value in TEMP to ASCII.
;
;Note that this routine does not care where the table is located.
;
Read_Table:

	andi	TEMP,0Fh		;Make sure it's impossible to read
					;past the end of the table.

	;If the length of the table was not a binary multiple, we'd probably
	;make a copy of temp, and subi the table length, and use the carry 
	;flag to indicate input out of range.

	ldi	ZL,low(BIN2ASC_TAB*2)	;Make the Z reg point at the table
	ldi	ZH,high(BIN2ASC_TAB*2)	;preparing for the LPM instruction

	;We have to use the Z register as the pointer for LPM, and LPM
	;also dictates that it's output will show up in R0

	add	ZL,TEMP			;Add the calculated offset
	brcc	RT_A			;If no carry, then we're done
	inc	ZH			;Handle carry
RT_A:	
	lpm				;look up character
	mov	TEMP,R0			;Put the output in temp.
	ret

