;***************************************************************************
; 
; File Name		:'random.asm"
; Title			:
; Date			:
; Version		:
; Support telephone	:765 287 1987  David B. VanHorn
; Support fax		:765 287 1989
; Support Email		:dvanhorn@cedar.net
; Target MCU		:AT90S8515
;
; DESCRIPTION
;
; DEFINITIONS
;
; 
;***************************************************************************;
;	M O D I F I C A T I O N   H I S T O R Y 
;
;
;       rev.      date    who   why
;	----	--------  ---	------------------------------------------
;	0.01	97.09.30  dvh	Creation
;	0.02	98.08.05  dvh	Making sure it works, plus tightening up.
;				6uS at 8 Mhz.
;	0.03	98.08.23  dvh	Removed some un-needed CLC instructions and
;				replaced roX with lsX's 
;	0.04	98.12.01  dvh	Removed two un-needed bit masks in the first part.
;
; 
;***************************************************************************;
;
Init_Random:
	ldi	TEMP,$AA	;Init the random number generator 
	mov	RAND1,TEMP	;since a 00,00,00 state will not 
	mov	RAND2,TEMP	;progress.
	mov	RAND3,TEMP	;
	ret
; 
;***************************************************************************;
;
Random:
	;Maximal legnth 19 bit shift register sequence,
	push	R16		;Make workspace
	push	R17		;

	;  RAND3    RAND2    RAND1
	;22222111 11111110 00000000
	;43210987 65432109 87654321

	mov	R16,RAND1	;Make copy
	mov	R17,RAND3	;Make copy

	;clc			;not needed, because we will overwrite bit 0 later
	rol	RAND1		;Shift the bits D7->Carry
	rol	RAND2		;Carry->D0 D7->Carry
	rol	RAND3		;Carry->D0 D7->Carry, but that will be fixed.

	;Now we have to Xor the bits to see what
	;goes in to bit 1

	rol	R17		;Move bit 19->20
	andi	R17,$08		;Important that D1,0 be zero

	andi	R16,$13		;Mask out irrelevants, protecting bit 19
	or	R17,R16		;Get bits 5->21 2->18 1->17

	andi	R17,$18		;Nuke bits 18,17
	lsr	R17		;19->19 5->20
	lsr	R17		;19->18 5->19
	lsr	R17		;19->17 5->18

	eor	R17,R16		;First xor, result in R17 (5x2 in 02 and 19x1 in 01)
	mov	R16,R17		;Make a copy
	ror	R16		;Move the 5x2 result to 01
	andi	R17,$01		;Mask off everything else
	andi	R16,$01		;in both
	eor	R17,R16		;
	brne	D_One		;If one, do that, else 

D_Zero:	
	;Set a zero in the lsb of the low byte
	mov	R16,RAND1	;Get the low byte
	andi	R16,$FE		;Make the LSB zero
	mov	RAND1,R16	;Put it back
	Rjmp	D_Exit		;Bye bye

D_One:	
	;Set a one in the lsb of the low byte
	mov	R16,RAND1	;Get the low byte
	ori	R16,$01		;Make the LSB one
	mov	RAND1,R16	;Put it back

D_Exit:
	pop	R17		;Put everything back where I got it.
	pop	R16		;
	ret

