
;***************************************************************************
; 
; File Name		:'MORSE.asm"
; Title			:
; Date			:
; Version		:
; Support telephone	:765 287 1987  David B. VanHorn
; Support fax		:765 287 1989
; Support Email		:dvanhorn@cedar.net
; Support Snail		;1104 E 13th St, Muncie IN 47302
; Target MCU		:AT90S8515
; 
;***************************************************************************;
;	D E S C R I P T I O N
;
;An ASCII to MORSE converter, supporting all legal morse chars, plus 
;prosigns as defined in the ARRL handbook.
; 
;***************************************************************************;
;	M O D I F I C A T I O N   H I S T O R Y 
;
;
;       rev.      date    who   why
;	----	--------  ---	------------------------------------------
;	0.01	98.10.19  dvh	Creation
;	0.02	99.09.09  dvh	I've been way too busy lately.
;				Modified to 16 bit "beeptime" to handle
;				inter-word spaces with slow speeds
;				Modified to be port-able :)
;
;************************************************************
;
;Hardware pins assigned here to logical names.
;
;
;You have to define things, before you can use them.
;Below, in the CSEG (Code Segment) I define some constants.
;Then, in the DSEG (Data segment) I use them to allocate some memory.
;If you reverse this order, the assembler may not pick up an error,
;But you will experience "non-deterministic execution".
;
.CSEG
.equ	Morse_Port=PORTD;Morse output port
.equ	Morse_DDR=DDRD;Must match above port
.equ	Morse_Bit=7	;Morse output bit
.equ 	Morse_Size = 40 	;Note the buffer is bigger by 2
;********************************************************************
;
;Morse variables
.DSEG
BEEPFLAG:	.byte	1	;Keeps track of the state
MBITS1:		.byte	1	;8 elements of storage,
MBITS2:		.byte	1	;dot, dash, or end.
BEEPTIME:	.byte	1	;dec'd by T0 ISR # of MS to stay beeping
BEEPTIME2:	.byte	1	;The high byte of above
M_SPEED:	.byte	1	;speed, in WPM or something.
Dots_2_Go:	.byte	1	;Handles dashes and others
Morse_OUT_BUF:	.byte	Morse_Size+2	;Size defined above
Morse_BITFLAGS:	.byte 1		;7=First, are we active, or not? 1=active
				;6=Beeping or not?  1=Beeping
				;5=Final Silence flag 1=final silent
				;4=Unused
				;3=Unused
				;2=Address within MORS1,2 for the current
				;1=element, 0-7
				;0=

.CSEG
;********************************************************************
;Note: Do NOT call WPM2SPD while anything is actively being sent!
;The division routines use M_SPEED as a temp location, and it will
;cause serious havoc with outgoing morse to have the value changing.
;
;We do not send a string here, because since morse is a communication 
;process, it eats it's buffer contents as it sends them. Once the buffer
;is empty, we stop sending anything, until someone fills it up again.
;There is a process in MAIN.ASM that puts messages into the morse output
;buffer so that it keeps sending things.
;
Init_Morse:
	ldi	TEMP,20		;120mS/Dit at 10
	rcall	WPM2SPD		;Translate words per minute to speed value
	ret			;
;********************************************************************
;
WPM2SPD:
	;Speed is in ms per dit
	;WPM is defined as sending PARIS N times per minute
	;in 60 seconds.
	;*b-b-b*s*b-s*b-b*b*b*s*b*b*
	;113131131133113113111311111 (dots) plus 7 for inter-word
	;113131 13113 311311 311131 1111
	;    10     9     10    10    4   7
	;50 dot times per minute = 1wpm
	;1 dot time therefore is 1200mS at 1WPM
	;1200/WPM = Speed?
	;
	;
	;Temp has desired WPM	;
	ldi	TEMP3,$04	;dividend high
	ldi	TEMP4,$0B	;dividend low

	;TEMP3,4 is the working pair
	ldi	TEMP2,0		;

div16Loop:
	sbc	TEMP4,TEMP	;Subtract 
	brcc	DivRup		;If no carry, then ok

	clc			;
	sbci	TEMP3,1		;
	brcc	DivRup		;
	rjmp	WPM2SPD_Done	;
	
DivRup:	inc	TEMP2		;
	rjmp	div16Loop	;


WPM2SPD_Done:
	sts	M_SPEED,TEMP2	;This is a dot-time
				;240 at 5wpm
	ret	;Nothing else to do.
;
;********************************************************************
;
CW_TEST1:
	mov	TEMP,RAND1		;Randomly output different messages
	andi	TEMP,$03		;
	cpi	TEMP,$03		;
	breq	CW_Msg_3		;
	cpi	TEMP,$02		;
	breq	CW_Msg_2		;
	cpi	TEMP,$01		;
	breq	CW_Msg_1		;

CW_Msg_Zero:
	;Test against a long dummy message
	;so we don't keep reloading the shortest 
	;message all the time.

	ldi	ZL,low(Morse_TESTD*2)	;Make the Z reg point at the table
	ldi	ZH,high(Morse_TESTD*2)	;preparing for the LPM instruction
	ldi	YL,low(Morse_Out_Buf)	;
	ldi	YH,high(Morse_Out_Buf)	;
	rcall	Test_Space		;Returns zero if the string won't fit
					;in the target buffer.
	breq	CW_Test_Done		;

	ldi	ZL,low(Morse_TEST0*2)	;Make the Z reg point at the table
	ldi	ZH,high(Morse_TEST0*2)	;preparing for the LPM instruction
	ldi	YL,low(Morse_Out_Buf)	;
	ldi	YH,high(Morse_Out_Buf)	;

	;Normally, we would test like this, using the message to 
	;be sent, but this dosent' work with the randomizer.
	;rcall	Test_Space		;Returns zero if the string won't fit
					;in the target buffer.
	;breq	CW_Test_Done		;

	rcall	String_out		;String to buf, buf to LCD
	rjmp	CW_Test_Done		;


CW_Msg_1:

	;Test against a long dummy message
	;so we don't keep reloading the shortest 
	;message all the time.

	ldi	ZL,low(Morse_TESTD*2)	;Make the Z reg point at the table
	ldi	ZH,high(Morse_TESTD*2)	;preparing for the LPM instruction
	ldi	YL,low(Morse_Out_Buf)	;
	ldi	YH,high(Morse_Out_Buf)	;
	rcall	Test_Space		;Returns zero if the string won't fit
					;in the target buffer.
	breq	CW_Test_Done		;

	ldi	ZL,low(Morse_TEST1*2)	;Make the Z reg point at the table
	ldi	ZH,high(Morse_TEST1*2)	;preparing for the LPM instruction
	ldi	YL,low(Morse_Out_Buf)	;
	ldi	YH,high(Morse_Out_Buf)	;
	rcall	String_out		;String to buf, buf to LCD
	rjmp	CW_Test_Done		;

CW_Msg_2:
	;Test against a long dummy message
	;so we don't keep reloading the shortest 
	;message all the time.

	ldi	ZL,low(Morse_TESTD*2)	;Make the Z reg point at the table
	ldi	ZH,high(Morse_TESTD*2)	;preparing for the LPM instruction
	ldi	YL,low(Morse_Out_Buf)	;
	ldi	YH,high(Morse_Out_Buf)	;
	rcall	Test_Space		;Returns zero if the string won't fit
					;in the target buffer.
	breq	CW_Test_Done		;
	ldi	ZL,low(Morse_TEST2*2)	;Make the Z reg point at the table
	ldi	ZH,high(Morse_TEST2*2)	;preparing for the LPM instruction
	ldi	YL,low(Morse_Out_Buf)	;
	ldi	YH,high(Morse_Out_Buf)	;
	rcall	String_out		;String to buf, buf to LCD
	rjmp	CW_Test_Done		;

CW_Msg_3:
	;Test against a long dummy message
	;so we don't keep reloading the shortest 
	;message all the time.

	ldi	ZL,low(Morse_TESTD*2)	;Make the Z reg point at the table
	ldi	ZH,high(Morse_TESTD*2)	;preparing for the LPM instruction
	ldi	YL,low(Morse_Out_Buf)	;
	ldi	YH,high(Morse_Out_Buf)	;
	rcall	Test_Space		;Returns zero if the string won't fit
					;in the target buffer.
	breq	CW_Test_Done		;

	ldi	ZL,low(Morse_TEST3*2)	;Make the Z reg point at the table
	ldi	ZH,high(Morse_TEST3*2)	;preparing for the LPM instruction
	ldi	YL,low(Morse_Out_Buf)	;
	ldi	YH,high(Morse_Out_Buf)	;
	rcall	String_out		;String to buf, buf to LCD
	rjmp	CW_Test_Done		;

CW_Test_Done:
	ret

;*********************************************************;
;
Morse_Test0:
.db	"CQ CQ CQ CQ CQ CQ DE KC6ETE  ",0
Morse_Test1:
.db	"HI HI  ",0
Morse_Test2:
.db	"HI SAILOR  BUY ME A DRINK?  ",0
Morse_Test3:
.db	"WHT DO U XPCT FRM A CHEAP CHIP?  ",0

;A dummy message, so the randomizer dosen't always pick
;the shortest message
Morse_TestD:
.db	"**********************************",0

;
;*********************************************************;
CW_SPEW:
	lds	TEMP,BEEPFLAG	;Are we working a char?
	andi	TEMP,$80	;
	brne	CW_Spew_Done	;If so, exit.

	;Point at the beginning of the Morse buffer
	ldi	YH,high(Morse_OUT_BUF)	;
	ldi	YL,low(Morse_OUT_BUF)	;
	ld	TEMP,Y+		;Skip the length
	ld	TEMP,Y+		;get the size
	cpi	TEMP,0		;If zero, then we're done.
	breq	CW_Spew_Done	;

	ld	TEMP,Y		;Get a char, and inc Y
	and	TEMP,TEMP	;Is it null?
	breq	CW_SPEW_Done	;Yes, all done
	rcall	ASC2Morse	;Otherwise look it up and send it
	ldi	YL,low(Morse_Out_Buf)	;Stored pointer to tail
	ldi	YH,high(Morse_Out_Buf)	;
	rcall	Kill_Head	;

CW_SPEW_Done:
	ret

;
;*************************************************************
;ASCII to Morse conversion
;*************************************************************
;
;
ASC2MORSE:

	subi	TEMP,$20	;Space is now zero
	breq	Go_Beep_Spc	;Trap out the space char, send as six dots of silence.
	subi	TEMP,2		;Space and next are not encoded
	rcall	Morsetran	;Translate to beep sets in MORS1
				;and MORS2
	;MBITS1,2 now indicate dot, dash, or end as follows:
	;
	;Each 2 bit entry is either a dot(00) dash (01) or stop (11)
	;not space-efficient, but real fast to look up, and
	;simple to code for.
	;
	;.DB	01000100 > MBITS1 ;-*-*  "C"
	;.DB	11111111 > MBITS2 ;End End End End
	;
	;Morse_Bitflags:
	;
	;X		First, are we active, or not? 1=active
	; X		Beeping or not?  1=Beeping
	;  X		Final Silence flag 1=final silent
	;   X
	;    X
	;     XXX	Address within MORS1,2 for the current
	;		element, 0-7
	;
	;What we do here is load MORS1,2 with the data from the 
	;table, and set bitflags to 11XXX000.
	;The 1ms opsys tick will now handle the output of the char
	;as it looks at bitflags on every pass.
	;
	;See T0_Morse in ISR.ASM for the rest. 


Go_Beep:
	ldi	TEMP,$C0	;11 000 000 (Incs the first time
	sts	BEEPFLAG,TEMP	;to 001)
	lds	TEMP,MBITS1	;
	andi	TEMP,$C0	;
	breq	Go_Beep_Dit	;Handle 00 (*)
	rjmp	Go_Beep_Dah	;Handle 01 (-)

Go_Beep_Dit:
	lds	TEMP,M_SPEED	;get the time reload
	sts	BEEPTIME,TEMP	;save it
	sbi	Morse_DDR,Morse_Bit;Make it an output
	sbi	Morse_Port,Morse_Bit	;output beep
	rjmp	Morse_Skip	;

Go_Beep_Dah:
	lds	TEMP,M_SPEED	;get the time reload
	sts	BEEPTIME,TEMP	;save it
	ldi	TEMP,2		;
	sts	Dots_2_Go,TEMP	;
	sbi	Morse_DDR,Morse_Bit;Make it an output
	sbi	Morse_Port,Morse_Bit;output beep
	rjmp	Morse_Skip	;


Go_Beep_Spc:
	ldi	TEMP,$A0	;1010 0000
	sts	BEEPFLAG,TEMP	;Indicate a silent beep
	lds	TEMP,M_SPEED	;get the time reload
	clr	TEMP2		;
	clr	TEMP3		;
	clr	TEMP4		;

	mov	TEMP3,TEMP	;Start with one

	clc			;X2
	rol	TEMP		;Make low byte
	add	TEMP2,ZERO	;and high byte

	clc			;
	add	TEMP3,TEMP	;Add lows
	adc	TEMP4,ZERO	;Handle Carry
	add	TEMP4,TEMP2	;Add high

	clc			;
	add	TEMP3,TEMP	;Add lows
	adc	TEMP4,ZERO	;Handle Carry
	add	TEMP4,TEMP2	;Add high

	clc			;
	add	TEMP3,TEMP	;Add lows
	adc	TEMP4,ZERO	;Handle Carry
	add	TEMP4,TEMP2	;Add high

	sts	BEEPTIME,TEMP3	;save it
	sts	BEEPTIME2,TEMP4

	sbi	Morse_DDR,Morse_Bit;Make it an output
	cbi	Morse_Port,Morse_Bit;output /beep
	ldi	TEMP,$FF	;
	sts	MBITS1,TEMP	;
	sts	MBITS2,TEMP	;
	rjmp	Morse_Skip	;

Morse_Skip:
	ret
;
;****************************************************************************
;
;Look up any entries that are in the table
;Input is ASCII-22h
;
Morsetran:

	ldi	ZL,low(MORSETAB*2)	;
	ldi	ZH,high(MORSETAB*2)	;
	rol	TEMP			;2 bytes per entry
	clc				;
	add	ZL,TEMP			;
	brcc	MT_A			;
	inc	ZH			;

MT_A:	lpm				;look up character
	sts	MBITS1,R0		;get byte 1
	adiw 	ZL,1			;point at next
	lpm				;get byte 2
	sts	MBITS2,R0		;store it
	ret				;all done
;
;****************************************************************************
;
;
MORSETAB:
	;Space and  ! are not encoded in morse, and so they
	;have no entry, but space is legal in ASCII. ASC2MORSE
	;strips these two before calling the table.

	;Each entry is either a dot(00) dash (01) or stop (11)
	;not space-efficient, but real fast to look up, and
	;simple to code for.

	;index is (ASCII-22h)*2  Convert LC to UC as morse has
	;no case.

	;illegals are all stop(11)
	;space is a special case that generates an inter
	;word timing.

	.db	$10,$4F 	;AF(22H)
	.DB	$FF,$FF		;  (23H)
	.DB	$40,$83		;SX(24H)
	.DB	$FF,$FF		;
	.db	$FF,$FF		;
	.DB	$15,$4f		;WG(27H)
	.DB	$FF,$FF		;
	.DB	$45,$3F		;KN(29H)
	.DB	$45,$1F		;KK
	.DB	$11,$3F		;AR
	.DB	$50,$5F		;MIM
	.DB	$40,$1F		;DU
	.DB	$11,$1F		;AAA
	.Db	$41,$3F		;DN
	.DB	$55,$7F		;0
	.DB	$15,$7F		;1
	.Db	$05,$7F		;2
	.db	$01,$7F		;3
	.DB	$00,$7F		;4
	.DB	$00,$3F		;5
	.DB	$40,$3F		;6
	.Db	$50,$3F		;7
	.DB	$54,$3F		;8
	.DB	$55,$3F		;9
	.DB	$54,$0F		;OS
	.DB	$44,$4F		;KR
	.DB	$FF,$FF		;
	.DB	$40,$7F		;BT
	.DB	$FF,$FF		;
	.DB	$05,$0F		;IMI
	.DB	$FF,$FF		;
	.DB	$1F,$FF		;A
	.DB	$40,$FF		;B
	.DB	$44,$FF		;C
	.DB	$43,$FF		;D
	.DB	$3F,$FF		;E
	.DB	$04,$FF		;F
	.DB	$53,$FF		;G
	.DB	$00,$FF		;H Dit Dit Dit Dit
	.DB	$0F,$FF		;I Dit Dit
	.DB	$15,$FF		;J
	.DB	$47,$FF		;K
	.DB	$10,$FF		;L
	.DB	$5F,$FF		;M
	.DB	$4F,$FF		;N
	.DB	$57,$FF		;O
	.DB	$14,$FF		;P
	.DB	$51,$FF		;Q
	.DB	$13,$FF		;R
	.DB	$03,$FF		;S
	.DB	$7F,$FF		;T
	.DB	$07,$FF		;U
	.DB	$01,$FF		;V
	.DB	$17,$FF		;W
	.DB	$41,$FF		;X
	.DB	$45,$FF		;Y
	.DB	$50,$FF		;Z
	.db	$FF,$FF		;
	.db	$FF,$FF		;
	.DB	$FF,$FF		;
	.db	$FF,$FF		;
	.DB	$03,$1F		;IQ(5f)

;
;*************************************************************
;