;***************************************************************************
; 
; File Name		:'MAIN.asm"
; Title			:
; Date			:
; Version		:5.0 coded for the atmel WAVRASM assembler
; Support telephone	:765 287 1987  David B. VanHorn
; Support fax		:765 287 1989
; Support Email		:dvanhorn@cedar.net
; Support Snail		;1104 E 13th St, Muncie IN 47302
; Target MCU		:AT90S8515
; 
;***************************************************************************;
;	D E S C R I P T I O N
;
; This is an application I put together to help people get started on the 
;ATMEL AVR 8515 processor. It's not complete by any means, I dont' think it's
;possible to use EVERY feature and mode.  Basically, I wanted to get you started,
;and help you avoid some sneaky traps that you can fall into. 
;
;Legal issues: I retain ownership of this software. I grant you the right to use
;the software to educate yourself on the intricacies of the 8515 processor, and 
;to use it for personal, non-commercial use. Anything else, email me. If you think
;this is a cool thing and want to encourage me to write more stuff, feel free to 
;send a donation.
;
;This application uses most (all?) of the features of the assembler itself, in
;terms of equates, defines, inline math, multiple file includes..
;
;This application uses timer 0 and timer 1, the UART and baud rate generator,
;all the I/O ports, and the watchdog timer.
;
;Active features:
;
;	Language interpreter   This reads a tokenized language stored in EEPROM,
;	and does whatever it says. There aren't a lot of commands implemented, 
;	just enough to get you started. The point is that you implement whatever
;	commands are suited to your application.
;
;	Pseudorandom number (PN) generator, This is implemented with a 19 bit
;	maximal length shift register. Each time the routine is called, the
;	bit pattern is shifted. The seed value is programmable, and the routine
;	leaves you randomized bits in three registers (Could easily be put in SRAM) 
;
;	1mS system "tick" (T0) Drives timeouts and timed events
;
;	Watchdog timer support, coded for the internal watchdog, but a simple
;	hack to drive external doggies. There is an equate to set the watchdog
;	"feed" interval, driven from the 1mS opsys tick
;
;	R/C Servo outputs. (T1) 
;	There is a programmable width for each servo, from 0-255 
;	Eight or less output channels are supported. 
;	Each channel has a byte in ram that sets it's position.  
;	There is a debug routine in the servo logic that provides
;	some action on channels 1-3 so you can see it do something immediately.
;	WARNING: Buffer the signal with at least a 1k resistor out to the servos.
;
;	Switch inputs (ok, so it's not hard..)
;	LED outputs, driven from the PN generator. Ditto
;
;	Stepper motor control. A single channel output for unipolar motors, with
;	flag bytes in RAM setting full or half step mode, and forward or reverse
;	direction, as well as speed in mS per step (or half-step)
;	WARNING: You're on your own for drivers, the 8515 won't run even the 
;	wimpiest stepper directly, don't even try. At a minimum, four NPN transistors
;	should do the trick.
;
;	Buffered serial input and output comms at popular baud rates. Also break
;	generation, and Xon/Xoff and hardware handshake.
;	There is a receive and a transmit buffer of configurable size.
;
;	Inter-Charachter delay on transmit. Not pacing with nulls, this is a true
;	delay, driven by the T0 interrupt. I've needed this from time to time to
;	talk to other devices that couldn't really handle full speed comms.
;	
;	Added customizable language interperter, with program flow control!
;
;Feel free to do something with them and send me a module to include in the package.
;
;PLEASE DO NOT HACK THIS AND PASS IT ON.
;Hack it for yourself all you like, but the main idea is to give newcomers software
;that does something, and that actually WORKS.. Your code might work, but the next
;guy might not be so clever. If you use this to create something else, please call it
;something else, and make it clear to whoever you give it to that it's YOUR creation.
;
;Old software rule #1: You modify it, you're on your own.
; 
;***************************************************************************;
;	M O D I F I C A T I O N   H I S T O R Y 
;
;
;       rev.      date    who   why
;	----	--------  ---	------------------------------------------
;	0.01	98.07.29  dvh	Creation
;	5.0	00.10.03  dvh	Added language interpreter, reading tokenized
;				data from EEPROM. Simple command set to start with,
;				but very expandable
;				Released to the public. 
;
;********************************************************************
;This application consists of seventeen files. They should all be in the
;same directory, or you will have to edit the .include directives 
;below to make them point to the right locations.
;
;Main.asm (You're looking at it)  The main structure of the program
;8515def.inc	Port and pin definitions, supplied by ATMEL
;Equates.inc  	Where constants get defined as words, to make life easier
;Isr.asm	Interrupt Service Routines
;Init.asm	Machine initialization
;Interp.asm	Tokenized command interpreter (NEW!)
;Keyboard.asm	Scanned keyboard support
;Memory.asm	Buffer management (MUCH REVISED!)
;Serial.asm	Serial comms using the on-board uart
;Servo.asm	Servo control code for eight standard R/C servos on PORTC 
;Stepper.asm	Stepper motor control for one unipolar motor on port A0-A3
;Random.asm	A 19 bit PseudoNoise generator
;Watchdog.asm	Watchdog timer code
;LCD4bit.asm	Handler for generic charachter based LCDs in 4 bit mode
;VFD.asm	Handler for Futaba Vaccum Flourescent Displays
;Morse.asm	Sends all legal morse code as ASCII to MORSE translation.
;EEPROM.asm	Handler for the internal EEPROM, coded to save and recall
;
;********************************************************************
;Physical resources.
;
;This application is designed for an AVR demo board, with 8.00 MHz crystal.
;For bonus points, modify it to use a 4 MHz xtal, without changing the speed 
;that anything runs at. That's a good first project!
;
;********************************************************************
;
;Logical equates to make life easier
;
.include "EQUATES.INC" ;The basics, naming of registers etc.
;It's far easter to remember what "LOOP" is for, than "R15"
;
.cseg ;This tells the assembler that what follows is code, and goes in ROMspace
;
;********************************************************************
;
;The actual beginning of the code.
;INIT the machine, start the ISRs, and exit into idle
;On reset, the 8515 jumps to 0000, which contains a jump vector (see ISR.ASM)
;
.include "Isr.asm"	;Restart vector and Interrupt service routines are here
.include "Init.asm"	;Initialization of timers,ports,and ext hdw.
;
;***********************************************************************
;
;We get here (Wherever here happens to end up) because of a vector in the 
;ISR.ASM file that defines what code gets executed on reset.
;
;$000
;	rjmp	INIT_Machine	;Restart vector, points to the beginning of the code. 
;
;Init_Machine is in INIT.ASM, and basically sets up the chip, turning things on
;and off as needed, and calling rouines in the other modules to set up various
;peripherals. At the end of all that, there is a line:
;
;	rjmp	Idle
;
;Which causes execution to jump to here. 
;At this point, the machine is up and running, the interrupts are enabled, timers 
;are counting, buffers and variables are all initialized, and we're ready to work.
;
;In the idle loop, I've defined some things for the CPU to do, so that you get the
;idea that it's actually doing something, but none of this between IDLE and the RJMP IDLE
;is strictly necessary.  You could remove any or all of it, and do whatever you like.
;All serial communication is happening in the background, so you should look in on the 
;serial in buffer once in a while, and maybe do something with whatever you find there.
;
;There is one needed routine in this loop, that's the RCALL TIMED_SMACK right before
;RJMP IDLE. The idea is that we check after each loop through IDLE, and if some time has
;passed, then we will reset the watchdog timer. If no real time has passed, then there's
;no need to reset the watchdog. 
;
;***************************************************************************************
;
Idle:	
	;
	;********************************************************
	;
	;Check the EEPROM memory, and see if there's some commands stored
	;If so, figure out what we should be doing, and do that.
	;Due to the EEPROM data bug, I don't store anything at 000h
	;The program memory begins at a settable point within the EEPROM
	;
	;This routine uses EEPROM.ASM to fetch commands from the internal
	;EEPROM area. There's no reason you couldn't use external EEPROM,
	;Just replace the call to "GET_EE" with one that reads the external.
	;
	rcall	Interp		;See if there's something we should be
				;doing.

	;
	;Thoughts for the future:
	;
	;Another fun idea would be to pre-load the EEPROM data out here in
	;the idle loop, sort of a prefetch cache. It does take a while to 
	;talk to the EEPROM, and we always know it's going to start at a 
	;defined base location. The logic would have to fetch a byte (or 
	;more) and have a list of locations cached. When the interpreter
	;wants data, then it would call for contents of an address, and the
	;cache logic would hand it up if in cache, or get it from EEPROM if 
	;not.
	;
	;********************************************************
	;
	;I haven't tested the keyboard code yet, but it should be ok.
	;
	;Look for keys on a 4x4 matrix
	;
Idle_Scan_Keys:
	;rcall	Scan_Keys		;
	;and	TEMP,TEMP		;Is it zero?
	;breq	Idle_No_Keys		;If so, then we didn't get any keys.
	;
Idle_Got_Keys:
	;Here, you would probably do something based on which key was pressed.

Idle_No_Keys:	;Dummy Label
	;
	;********************************************************
	;
	;Test morse output MORSE.ASM
	rcall	CW_Test1	;Randomly puts one of four strings into
				;the CW output buffer, when there's room
				;for them to fit, otherwise it just exits.

	rcall	CW_Spew		;If there's contents in the CW output buffer,
				;then this starts transmitting it, and the T0
				;ISR will handle the remaining part of the char.
				;If the ISR is already sending something, then
				;this just exits.
	;
	;********************************************************
	;
	;This just keeps sending "Quick Brown Fox" messages over and over,
	;but it does illustrate interrupt driven buffered serial comms.
	;
	rcall	Ser_Test1	;SERIAL.ASM
	;
	;If there's room in the serial output buffer, then this places a
	;message in the buffer. When the T0 ISR checks the buffer, it will enable
	;the serial out ISR to start sending chars if the serial out buffer
	;is not empty.
	;Otherwise, it just exits.
	
Idle_Scan_Test:
	;cli				;Debug, keeps comm ints from making a
					;concentration nightmare

	ldi	YH,high(Serial_Out_Buffer)	;Point at the beginning
	ldi	YL,low(Serial_Out_Buffer)	;
	ldi	TEMP,$46		;Scan for this
	ld	TEMP2,Y			;This gets the current length
	cp	TEMP2,ZERO		;Is it empty?
	breq	Idle_Scan_Test_done	;Nothing there, no need to scan
	rcall	Circ_Scan		;

Idle_Scan_Test_Done:
	;sei				;Only use this if CLI is uncommented above

	;********************************************************************
	;Take serial input, and put it on the display(s)
	;
	; Commented out for idle scroll display
	;
	;rcall	Get_Serial_In		;
	;brcc	Ser_Test_Done		;If carry is set, we got something,
	;rcall	LCD_Put_Char		;Show it on the display

Ser_Test_Done:
	;Dummy label

	
	;********************************************************
	;
	;VFD display handler
	;
	;
	;
	rcall	VFD_Scroll	;Based on the system timer, this routine
				;will scroll the text in the VFD buffer
				;as desired, and flag the contents as
				;"dirty" so that the next routine will
				;output the buffer to the display. 
				;If it's not time to scroll yet, then
				;we just exit, and the buffer remains 
				;"clean".
	;
	;This routine checks to see if VFD_OUT_BUF has been changed, by
	;looking at a particular bit in a byte called "BITFLAGS"
	;If the bit is set, then the display needs to be updated from the
	;buffer, otherwise nothing needs to be done.
	;
	rcall	Check_VFD_Display ;
	;
	;********************************************************
	;
	;LCD display handler
	;
	rcall	LCD_Scroll		;Same as above, different hdw.
	rcall	Check_LCD_Display	;Updates display if dirty
	;
	;
	;********************************************************
	;
	;Spin the random number generator.
	;
	rcall	Random			;Result in RAND1,RAND2,and RAND3
	;
	;Light output turned off, I'm using those bits for other things.
	;Random is output to one RC servo output. Look in the servo code
	;
	;out	PORTB,RAND1		;Output to the lights
	;Without a scope, you'll just see lights that are half-bright.
	;Random is used in the morse and servo routines as coded, so
	;that the demo isn't so boring :)
	;
	;********************************************************
	;
	;Here's where to do a dirt-simple switches and lights demo.
	;Jumper port D to the switches, and port B to the lights.
	;
	;Commented out, because way too much going on with those bits!
	;
	;Get the switches and light the lights (currently turned off)
	;The switches are used in SERVO.ASM to control some of the servo outputs.
	;
	;The needed hardware setups:
	;ldi	TEMP,$00		;
	;out	DDRD,TEMP		;Make port D inputs
	;ldi	TEMP,$FF		;
	;out	PORTD,TEMP		;Make the pullups on
	;out	DDRB,TEMP		;Make port B all outputs
	;
	;And the part that does all the work.
	;in	TEMP,PIND		;Input the switches
	;out	PORTB,TEMP		;Output to the lights
	;
	;NOTE! The switch inputs are active low, an un-pushed switch
	;gives a "1" input. This results in LED off, if the pin status
	;is fed out to PORTB, due to how the LEDs are wired.
	;
	;NOTE! A LOW output state lights the LEDs. NOT a HIGH!!!
	;
	;
	;********************************************************
	
	rcall	Check_EE		;
	
	

	;********************************************************
	;
	;NOTE: The servos have width values set in INIT, and 
	;min-max values set in EQUATES.
	;You should set the min-max to match your servos, and 
	;load the widths you want into the servo control bytes.
	;
	;This routine moves data in ram to the servos, if it's time to do so.
	;Servo data is held in RAM locations, SERVO_0 - SERVO_7
	;The servo code could easily be changed to output more or fewer servos.
	;
	rcall	Servo_Frame_Check	;Move the servos, if it's time (Servo.asm)
	;
	;
	;********************************************************
	;
	;NOTE: The stepper is set to OFF in INIT.ASM, you'll need to set
	; a direction, mode and step-rate before you'll get any output.
	;
	;Commented out, again, because too much else going on
	;
	;rcall	Step_Motor		;Step the stepper, if it's time (Stepper.asm)
	;
	;
	;********************************************************
	;
	;You could put something here to react to RS-232 input, and/or create RS-232
	;output based on switch inputs, the random generator, send messages.. Up to you!
	;
	;You could write a subsumption based robot controller, I've given you a bunch 
	;of bot-useful I/O functions that really work, and a ton of free CPU cycles.
	;
	;The step motor driver needs an interface capable of handling the load, but
	;the output pins are wiggling properly, just don't try to connect a stepper
	;directly to the chip. A set of four NPN transistors with protection diodes 
	;will work acceptably well for small motors with the motor common leads 
	;(2 usually) tied to a suitable power supply. Don't try to run steppers off 
	;the development board power supply, you'll glitch the CPU. 
	;
	;********************************************************
	;
	;If you use Ping, make sure it's assigned to an unused output pin, otherwise
	;it will cause problems with whatever else is trying to use that port.
	;
	;ldi	TEMP,$01		;A ping every time we loop.
	;rcall	Ping			;

	rcall	Timed_Smack		;Feed the watchdog, if it's needed (Watchdog.asm)

	rjmp	Idle			;

;*************************************************************************************
;I really hate doing things like this, but so far, I haven't hit on
;a good alternative.

MS_Delay:
	push 	TEMP2
	push	TEMP3

MS_Delay_1:
	ldi	TEMP2,$FF
MS_Delay_2:
	ldi	TEMP3,$10
MS_Delay_3:
	dec	TEMP3
	brne	MS_Delay_3

	dec	TEMP2
	brne	MS_Delay_2

	wdr			;Because otherwise we might get whacked
	dec	TEMP
	brne	MS_Delay_1

	pop	TEMP3
	pop	TEMP2
	ret	
;
;********************************************************************
;
;A terribly useful little diagnostic hack, provided you've got a scope.
;Just call Ping with a number in TEMP, and it will give you N pulses.
;This is very useful for figuring which branch of a program is taken 
;on live hardware, when you haven't got an emulator, and simulation 
;isn't really an option.
;
.equ	Ping_Data=PORTA		;Which port will we use?
.equ	Ping_DDR=PORTA		;Must match above
.equ	Ping_Bit=1		;Ping output bit
;
Ping:
	sbi	Ping_DDR,Ping_Bit	;Make sure it's an output
	sbi	Ping_Data,Ping_Bit	;I hope your scope can resolve to 125nS
	cbi 	Ping_Data,Ping_Bit	;
	dec	TEMP			;One less ping
	brne	Ping			;Are we done? If not, then ping again
	ret				;If so, bye!
;********************************************************************
;External Routines
;
.include "circser.asm"	;Circularly buffered serial I/O
.include "EEPROM.asm"	;EEPROM save and recall
.include "Interp.asm"	;Command interpreter
.include "keyboard.asm"	;Scanned keyboard handler
.include "LCD4BIT.asm"	;Standard LCD code in 4 bit mode
.include "Memory.asm"	;Memory allocation, buffer handlers
.include "morse.asm"	;ASCII text to Morse code converter
.include "Random.asm"	;Pseudorandom generator, Specifically, a 19
			;bit maximal length generator.
.include "Servo.asm"	;RC Servo drivers, 8 channels on port C using timer 1
.include "Stepper.asm"	;5/6 wire unipolar motor driver
.include "VFD.asm"	;VFD display controller
.include "Watchdog.asm"	;Watchdog timer handler
;
;***************************************************************************
;
.db	"COPYRIGHT 1997-2000 David VanHorn",CR,LF
.db	"ALL RIGHTS RESERVED",CR,LF
;
;***************************************************************************
