
; File Name		:keyboard.asm
; Title			:Multiplexed keyboard routines
; Date			:
; Version		:
; Support telephone	:765 287 1987  David B. VanHorn
; Support fax		:765 287 1989
; Support Email		:dvanhorn@cedar.net
; Target MCU		:AT90S8515
;
; DESCRIPTION
; Simple 4 x 4 keyboard, can be scaled up or down
;
;***************************************************************************;
;	M O D I F I C A T I O N   H I S T O R Y 
;
;
;       rev.      date    who   why
;	----	--------  ---	------------------------------------------
;	0.01	99.09.13  dvh	Creation
;
;***************************************************************************;
;Note: You can simplify this greatly if you assume that the keyboard
;will always occupy at least four sequential bits on a port for row and
;column, but this example allows any eight pins to be used, on any two
;ports, with the only restriction that all the row pins are on one port,
;and all the column pins are on one port (not necessarily a different port)
;***************************************************************************;
;
;HARDWARE YOU NEED TO SET UP
;Hardware pins assigned here to logical names.
;This makes the code a little awkward, but you can put the pins 
;almost anywhere
;
.equ	KBD_COL=PORTD	;Keyboard Column port (Outputs!)
.equ	KBD_COL_DDR=DDRD;So we can control the direction
;
.equ	KBD_ROW=PIND	;Keyboard Row port (Inputs)
.equ	KBD_Row_PU=PORTD;So we can turn on the pullups
.equ	KBD_ROW_DDR=DDRD;So we can control the direction
;
.equ	KBD_C0=0	;Place the column bits anywhere
.equ	KBD_C1=1	;Place the column bits anywhere
.equ	KBD_C2=2	;Place the column bits anywhere
.equ	KBD_C3=3	;Place the column bits anywhere

.equ	KBD_R0=4	;Place the row bits anywhere
.equ	KBD_R1=5	;Place the row bits anywhere
.equ	KBD_R2=6	;Place the row bits anywhere
.equ	KBD_R3=7	;Place the row bits anywhere
;
;This is an example only, you can vary these settings, but this 
;is what I used.
;
;*************************************************************
;
;
.CSEG
.equ	Key_Interval=20	;Ms between keyboard scans
;
;********************************************************************
;Keyboard variables
;
;You have to define things, before you can use them.
;Below, in the CSEG (Code Segment) I define some constants.
;Then, in the DSEG (Data segment) I use them to allocate some memory.
;If you reverse this order, the assembler may not pick up an error,
;But you will experience "non-deterministic execution".
;
.DSEG
Old_Keys_1:	.byte	1	;Keeps track of the previous state
Old_Keys_2:	.byte	1	;
Key_Timer:	.byte	1	;How long before the next scan? (ISR0)
;
;Using the system timer to pace keyscans eliminates the need for debouncing.
;If a key indicates closed in two sequential scans, then it's closed. Period.
;
.CSEG
;
;*************************************************************
;
Init_Kbd:
	;Columns are outputs
	sbi	KBD_Col_DDR,KBD_C0	;Make it an output
	sbi	KBD_Col_DDR,KBD_C1	;Make it an output
	sbi	KBD_Col_DDR,KBD_C2	;Make it an output
	sbi	KBD_Col_DDR,KBD_C3	;Make it an output

	;Idle state is high, since the inputs have pullups.
	;You can go the other way, but you have to provide
	;pulldowns externally.

	sbi	KBD_COL,KBD_C0		;Make it high
	sbi	KBD_COL,KBD_C1		;Make it high
	sbi	KBD_COL,KBD_C2		;Make it high
	sbi	KBD_COL,KBD_C3		;Make it high

	;Rows are inputs

	cbi	KBD_Row_DDR,KBD_R0	;Make it an input
	cbi	KBD_Row_DDR,KBD_R1	;Make it an input
	cbi	KBD_Row_DDR,KBD_R2	;Make it an input
	cbi	KBD_Row_DDR,KBD_R3	;Make it an input

	sbi	KBD_Row_PU,KBD_R0	;Pull it high
	sbi	KBD_Row_PU,KBD_R1	;Pull it high
	sbi	KBD_Row_PU,KBD_R2	;Pull it high
	sbi	KBD_Row_PU,KBD_R3	;Pull it high

	ldi	TEMP,Key_Interval	;Load the scan timer
	sts	Key_Timer,TEMP		;

	ldi	TEMP,$00		;Indicate no keys previously
	sts	Old_Keys_1,TEMP		;pressed
	sts	Old_Keys_2,TEMP		;

	ret
;
;	;Assuming everything's on one port, you can just do this:
;	ldi	TEMP,$F0		;OUTS(7,6,5,4),INS(3,2,1,0)
;	out	DDRC,TEMP		;Make it so (PORTC, cause it's got no specials)
;	ldi	TEMP,$FF		;Set up column outs and pullups.
;	out	PORTC,TEMP		;Make it so
;	ldi	TEMP,Key_Interval	;Load the scan timer
;	sts	Key_Timer,TEMP		;
;	ldi	TEMP,$00		;Indicate no keys previously
;	sts	Old_Keys_1,TEMP		;pressed
;	sts	Old_Keys_2,TEMP		;
;	ret
;
;*************************************************************
;Returns zero if no key was pressed.
;Only returns a non-zero value if the current key state matches
;the old key state from the last keyboard scan.
;Output key values are in OLD_KEYS_1 and OLD_KEYS_2 as high bits
;Old_Keys_1 holds column 0 and 1 in the low and high nybbles
;Old_Keys_2 holds column 2 and 3 in the low and high nybbles
;Rows are sequential from 0-3 or 4-7 
;
;So, if the calling routine gets a zero from TEMP, then there's nothing
;going on in the keys.
;If it gets non-zero, then it can find all the keys currently pressed
;by looking at Old_Keys_1, and Old_Keys_2 and seeing which bits are high.
;
;There are many ways to report the keys, this is just one way.
;
Scan_Keys:
	lds	TEMP,Key_Timer		;Get the timer byte
	and	TEMP,TEMP		;Is it zero?
	breq	Now_Scan_Keys		;If zero, then scan the keys,
	ldi	TEMP,$00		;else return, with zero in temp
	ret				;

Now_Scan_Keys:
	ldi	TEMP,Key_Interval	;Reload the timer
	sts	Key_Timer,TEMP		;

	ldi	TEMP,$00		;Clear out temp
	mov	TEMP2,TEMP		;and temp2

	;Look for anything on column zero
	cbi	KBD_COL,KBD_C0		;Make it low
	nop				;
	sbis	KBD_Row,KBD_R0		;Check row 0
	ori	TEMP,$01		;Store a 1 if it's low
	sbis	KBD_Row,KBD_R1		;Check row 1
	ori	TEMP,$02		;Store a 2 if it's low
	sbis	KBD_Row,KBD_R2		;Check row 2
	ori	TEMP,$04		;Store a 4 if it's low
	sbis	KBD_Row,KBD_R3		;Check row 3
	ori	TEMP,$08		;Store an 8 if it's low
	sbi	KBD_COL,KBD_C0		;Make it high

	;Look for anything on column one
	cbi	KBD_COL,KBD_C1		;Make it low
	nop				;
	sbis	KBD_Row,KBD_R0		;Check row 0
	ori	TEMP,$10		;Store a 1 if it's low
	sbis	KBD_Row,KBD_R1		;Check row 1
	ori	TEMP,$20		;Store a 2 if it's low
	sbis	KBD_Row,KBD_R2		;Check row 2
	ori	TEMP,$40		;Store a 4 if it's low
	sbis	KBD_Row,KBD_R3		;Check row 3
	ori	TEMP,$80		;Store an 8 if it's low
	sbi	KBD_COL,KBD_C1		;Make it high

	;Look for anything on column two
	cbi	KBD_COL,KBD_C2		;Make it low
	nop				;
	sbis	KBD_Row,KBD_R0		;Check row 0
	ori	TEMP2,$01		;Store a 1 if it's low
	sbis	KBD_Row,KBD_R1		;Check row 1
	ori	TEMP2,$02		;Store a 2 if it's low
	sbis	KBD_Row,KBD_R2		;Check row 2
	ori	TEMP2,$04		;Store a 4 if it's low
	sbis	KBD_Row,KBD_R3		;Check row 3
	ori	TEMP2,$08		;Store an 8 if it's low
	sbi	KBD_COL,KBD_C2		;Make it high

	;Look for anything on column Three
	cbi	KBD_COL,KBD_C3		;Make it low
	nop				;
	sbis	KBD_Row,KBD_R0		;Check row 0
	ori	TEMP2,$10		;Store a 1 if it's low
	sbis	KBD_Row,KBD_R1		;Check row 1
	ori	TEMP2,$20		;Store a 2 if it's low
	sbis	KBD_Row,KBD_R2		;Check row 2
	ori	TEMP2,$40		;Store a 4 if it's low
	sbis	KBD_Row,KBD_R3		;Check row 3
	ori	TEMP2,$80		;Store an 8 if it's low
	sbi	KBD_COL,KBD_C3		;Make it high

	;At this point, temp and temp2 have a 16 bit map of all the 
	;keys that are pressed. Now we need to compare them to
	;the old key state, and see if it is the same.
	;If so, then the keyboard is stable, and we can report a 
	;pressed key. If not, then we have to try again.

	;Get the old state
	lds	TEMP3,Old_Keys_1	;
	lds	TEMP4,Old_Keys_2	;
	;Save the now state		
	sts	Old_Keys_1,TEMP		;
	sts	Old_Keys_2,TEMP		;

	cp	TEMP,TEMP3		;
	brne	Scan_Keys_None		;
	cp	TEMP2,TEMP3		;
	brne	Scan_Keys_none		;

	;We only get here if the key states above both matched.
Scan_Keys_Valid:
	ldi	TEMP,$FF		;Signal a key is pressed
	rjmp	Scan_Keys_Done		;Get your output in Old_Keys_2

Scan_Keys_none:
	ldi	TEMP,$00		;

Scan_Keys_Done:
	ret
;
;*************************************************************
;
