; 
; File Name		:'ISD.asm"
; Title			:ISD Chip handlers
; Date			:
; Version		:
; Support telephone	:765 287 1987  David B. VanHorn
; Support fax		:765 287 1989
; Support Email		:dvanhorn@cedar.net
; Target MCU		:AT90S8515
;
; DESCRIPTION
; ISD Chipcorder routines
;
;***************************************************************************
;	M O D I F I C A T I O N   H I S T O R Y 
;
;
;       rev.      date    who   why
;	----	--------  ---	------------------------------------------
;	0.01	98.10.29  dvh	Creation
;
;	Skeleton for an ISD voice recorder chip
;
;
;***************************************************************************
;INT happens on end of memory, in play or record.
;
Play_ISD:
	rcall	ISD_Powerup
	;Delay
	;Set address=00
	rcall	ISD_Setplay
	rcall	ISD_Play
	ret

Record_ISD:
	rcall	ISD_Powerup
	;Delay
	rcall	ISD_Powerup
	;Delay
	;Delay
	;Set Address=00
	rcall	ISD_Setrec
	rcall	ISD_Rec
	ret
;
;***************************************************************************
;The top level ISD commands.
;***************************************************************************

;VERIFY THESE OPCODES!

ISD_Powerup:
	;Opcode 00100
	ldi	TEMP,$20		;
	sts	ISD_OUT_BUF,TEMP	;
	ldi	TEMP,$00		;Adrs don't care
	sts	ISD_OUT_BUF+1,TEMP	;
	rcall	Send_SPI
	ret

ISD_Setplay:
	;Opcode 11100
	ldi	TEMP,$E0		;
	sts	ISD_OUT_BUF,TEMP	;
	rcall	SET_ISD_ADRS		;Address X,A9-A0
	rcall	Send_SPI
	ret

ISD_Play:
	;Opcode 11110
	ldi	TEMP,$F0		;
	sts	ISD_OUT_BUF,TEMP	;
	;Address Don't Care
	ldi	TEMP,$00		;
	sts	ISD_OUT_BUF+1,TEMP	;
	rcall	Send_SPI
	ret

ISD_Setrec:
	;Opcode	10100
	ldi	TEMP,$A0		;
	sts	ISD_OUT_BUF,TEMP	;
	rcall	SET_ISD_ADRS		;Address X, A9-A0
	rcall	Send_SPI
	ret

ISD_REC:
	;Opcode 10110
	ldi	TEMP,$B0		;
	sts	ISD_OUT_BUF,TEMP	;
	;Address Don't Care
	ldi	TEMP,$00		;
	sts	ISD_OUT_BUF+1,TEMP	;
	rcall	Send_SPI
	ret

ISD_SETMC:
	;Opcode 11101
	;Address X,A9-A0
	rcall	Send_SPI
	ret

ISD_MC:
	;Opcode 1111
	ldi	TEMP,$F0		;
	sts	ISD_OUT_BUF,TEMP	;
	;Address Don't Care
	ldi	TEMP,$00		;
	sts	ISD_OUT_BUF+1,TEMP	;
	rcall	Send_SPI
	ret

ISD_Stop:
	;Opcode 0X110
	ldi	TEMP,$30		;
	sts	ISD_OUT_BUF,TEMP	;
	;Address Don't Care
	ldi	TEMP,$00		;
	sts	ISD_OUT_BUF+1,TEMP	;
	rcall	Send_SPI
	ret

ISD_Stop_Pwrdn:
	;Opcode 0X01X
	ldi	TEMP,$10		;
	sts	ISD_OUT_BUF,TEMP	;
	;Address Don't Care
	ldi	TEMP,$00		;
	sts	ISD_OUT_BUF+1,TEMP	;
	rcall	Send_SPI
	ret

ISD_Rint:
	;Opcode 0X110
	ldi	TEMP,$30		;
	sts	ISD_OUT_BUF,TEMP	;
	;Address Don't Care
	ldi	TEMP,$00		;
	sts	ISD_OUT_BUF+1,TEMP	;
	rcall	Send_SPI
	ret
;******************************************************************
;Let's have a short, fast, conversation
;Page 5-46 in the databook
;
;16 bit buffers in SRAM for 16 bit ops. (ISD_OUT_BUF, ISD_IN_BUF)
;One 8 bit register, (SPI_OUT_BUF) since we can't move direct from SRAM to I/O
;
;First enable the SPI port
;
;We take the ISD_OUT_BUF, and put it in SPI_OUT_BUF, and mark the incoming
;data as dirty (X0XXXXXX in BITFLAGS)
;Assert SS, which signals the slave
;Then we load SPI_OUT_BUF into SPDR, which initiates the transfer.
;We wait until the SPI RX ISR tells us it's done by setting X1XXXXXX in BITFLAGS
;Then we load SPDR into ISD_IN_BUF (high byte), and mark the data dirty again.
;Then we load ISD_OUT_BUF+1 into SPI_OUT_BUF
;Next we load SPI_OUT_BUF into SPDR
;We wait again for the ISR
;De-assert SS
;We load SPI_IN_buf to ISD_IN_BUF+1
;And we're done.


Send_SPI:
	rcall	Enable_SPI	;

	lds	SPI_OUT_BUF,ISD_OUT_BUF;Get it from SRAM

	mov	TEMP,BITFLAGS	;Signal that the data is no good.
	ori	TEMP,$BF	;
	mov	BITFLAGS,TEMP	;

	cbi	PORTB,4		;Take SS low		;Assert master
	out	SPDR,SPI_OUT_BUF;Start talking

SS_Wait1:	;Wait till it's done
	mov	TEMP,BITFLAGS	;
	andi	TEMP,$BF	;
	breq	SS_Wait1	;

	sts	ISD_IN_BUF,SPDR	;Store the inbound data
	lds	SPI_OUT_BUF,ISD_OUT_BUF+1;Get it from SRAM

	mov	TEMP,BITFLAGS	;Signal that the data is no good.
	andi	TEMP,$BF	;
	mov	BITFLAGS,TEMP	;

	cbi	PORTB,4		;Take SS low		;Assert master
	out	SPDR,SPI_OUT_BUF	;
	
SS_Wait2:	;Wait till it's done, then
	mov	TEMP,BITFLAGS	;
	andi	TEMP,$BF	;
	breq	SS_Wait2	;

	sbi	PORTB,4		;Take SS High		;De-assert master	
	sts	ISD_IN_BUF+1,SPDR	;

	ret

;********************************************
;Enable the SPI port
;********************************************
Enable_SPI:
	in	TEMP,SPCR	;
 
	;Choose one!
	ori	TEMP,$80	;Enable SPI INT
	;andi	TEMP,$7F	;Disable SPI INT

	;Choose one!
	ori	TEMP,$40	;Enable SPI interface
	;andi	TEMP,$BF	;Disable SPI interface

	;Choose one!
	;ori	TEMP,$20	;Enable data order LSB first
	andi	TEMP,$DF	;Enable data order MSB first 

	;Choose one!
	ori	TEMP,$10	;Enable Master mode.
	;andi	TEMP,$EF	;Enable Slave mode

	;Choose one!	
	;andi	TEMP,$F7	;Set SCK low idle
	ori	TEMP,$08	;Set SCK high idle

	;Choose one!
	andi	TEMP,$FB	;Set Clock phase (5-48 fig 41), CPOL=0
	;ori	TEMP,$04	;Set Clock phase (5-48 fig 41), CPOL=1

	;Choose one!
	andi	TEMP,$FC	;Fcl/4	
	;ori	TEMP,$01	;Fcl/16
	;ori	TEMP,$02	;Fcl/64
	;ori	TEMP,$03	;Fcl/128

	out	SPCR,TEMP	;

	;Set the pins properly
	in	TEMP,DDRB	;
	ori	TEMP,$10	;Make SS an output
	ori	TEMP,$80	;Make SCK an output
	ori	TEMP,$20	;Make MOSI an output
	out	DDRB,TEMP	;

	ret
