;***************************************************************************
; 
; File Name		:'EQUATES.INC"
; Title			:
; Date			:
; Version		:
; Support telephone	:765 287 1987  David B. VanHorn
; Support fax		:765 287 1989
; Support Email		:dvanhorn@cedar.net
; Target MCU		:AT90S8515
;
; DESCRIPTION
;
; DEFINITIONS
;
; 
;***************************************************************************;
;	M O D I F I C A T I O N   H I S T O R Y 
;
;
;       rev.      date    who   why
;	----	--------  ---	------------------------------------------
;	0.01	98.06.22  dvh	Began life as a separate file
;	0.02	98.08.20  dvh	Added servo support
;	0.03	98.08.21  dvh	Added FRAME_RATE to initialize FRAME_DELAY for
;				SERVO.ASM and INT.ASM 
;				Changed Frame_Delay to SRAM rather than register
;	0.04	98.08.30  dvh	Added Watchdog timer support
;	0.05	99.09.13  dvh	Added keyboard support
;	0.06	99.09.14  dvh	Removed serial buffer entries, new circular
;				buffer in sercirc.asm
;	0.07	99.09.15  dvh	Removed peripheral oriented stuff. That now
;				lives in each peripheral's file, along with
;				pin definitions and equates.
;	0.08    00.10.01  dvh   Comments
;
;********************************************************************
;HUGE WARNING!  If the "device" line is left uncommented, the assembler
;will catch unimplemented opcodes, but it will NOT generate a hex file!
;Leave this on (uncommented) until things are assembling well, then turn
;it off for making a chip. If things stop working mysteriously, then turn
;the device directive back on, and you'll probably find that you CALLed a
;routine, rather than RCALLing it.
;
;NOTE: This seems to be fixed as of Studio 3.21
;********************************************************************
.DEVICE AT90S8515
;
.include "8515def.inc" ;Atmel supplied file that is a standard list of
;			;equates for on-chip peripherals and such
;********************************************************************
;Universal Truths
;
.dseg ;This tells the assembler that what follows is data, not code
;
.equ	TRUE	=0FFh		;Yes
.equ	FALSE	=00h		;No
;
;********************************************************************
;Revision perversion
;
;It's lame, but you can't use "0" or "1", you have to specify in hex
;if you want to put it in a message like this:
;VERSION: .db	"FIRMWARE VERSION ",MAJOR_REV,".","MINOR_REV","MINOR_REVB",CR,LF
;
.equ	MAJOR_REV	=$34 	;Four
.equ	MINOR_REV	=$30	;Zero
.equ	MINOR_REVB	=$30	;Zero
;
;********************************************************************
;Timer setup.
;No storage needed, this just calculates a value for the timer based on
;the desired sample rate and the clock frequency, with constants for the
;internal chip prescalers and dividers.
;
.equ	XTAL		=8000000;in Hz
.equ	T0_DIV1		=$01	;
.equ	T0_DIV8		=$02	;
.equ	T0_DIV64	=$03	;
.equ	T0_DIV256	=$04	;
.equ	T0_DIV1024	=$05	;
.equ	T0DIV		=(255-127)	;Make for even MS! 1% error
;
;********************************************************************
;
;ASCII Equivalents
;
.equ	NUL=$00		;Null
.equ	SOH=$01		;Start of Header
.equ	STX=$02		;Start of Text
.equ	ETX=$03		;End of Text
.equ	EOT=$04		;End of Transmission
.equ	ENQ=$05		;Enquiry
.equ	ACK=$06		;Acknowlege
.equ	BEL=$07		;Bell
.equ	BS=$08		;Backspace
.equ	HT=$09		;Horizontal Tab
.equ	LF=$0A		;Line Feed
.equ	VT=$0B		;Vertical Tab
.equ	FF=$0C		;Form Feed
.equ	CR=$0D		;Carriage Return
.equ	SO=$0E		;
.equ	SI=$0F		;

.equ	DLE=$10		;Delete
.equ	XON=$11		;AKA DC1
.equ	XOFF=$12	;AKA DC2
.equ	DC3=$13		;
.equ	DC4=$14		;
.equ	NAK=$15		;Negative Acknowlege
.equ	SYN=$16		;Sync 
.equ	ETB=$17		;
.equ	CAN=$18		;Cancel
.equ	EM=$19		;
.equ	SUB=$1A		;
.equ	ESC=$1B		;
.equ	FS=$1C		;Field Separator
.equ	GS=$1D		;Group Separator
.equ	RS=$1E		;Record Separator
.equ	US=$1F		;
;
;********************************************************************
;
;Register equates
;
;All registers below 16 are the "cheap seats". It takes a little
;more to move data around in them. Registers 16 and up are faster
;to work with, plus 26-31 have special uses. R0 does as well, but
;it's only used in pulling from tables, and we can push it.
;
;Even though it looks like most of the registers are "eaten up",
;there's really plenty left. If you get desperate, try moving things
;to SRAM locations (penalty of an LDS and maybe STS to use them)
;IMHO, the ISR's should be as fast as possible, so I dedicate registers
;to them. You could push and pop, or use SRAM with the additional time penalty.
;
.def	EPROM_DATA	=R0	;Reserve this for LPM accesses (not STRICTLY necessary)
.def	RAND1		=R1	;Random number generator needs three
.def	RAND2		=R2	;bytes. This could just as well be
.def	RAND3		=R3	;SRAM, but it would be a little slower
.def	UD4		=R4	;
.def	TEMP7		=R5	;Only used in the servo code
.def	ZERO		=R6	;Always Zero!
.def	UD07		=R7	;
.def	UD08		=R8	;The cheap seats. Use these where possible,
.def	UD09		=R9	;once the code is working with high regs, convert
.def	UD10		=R10	;to low regs if workable. Costs 1 extra instr to set.
.def	UD11		=R11	;
.def	UD12		=R12	;

.def	LOOP		=R13	;Loop counter, local usage only.
.def	SPIBUFL		=R14	;SPI communication buffer for 16 bit conversation
.def	SPIBUFH		=R15	;to SPI peripherals

.def	TEMP		=R16	;The temps can't be in the cheap seats, because
.def	TEMP2		=R17	;they are used in ISRs where 100s of nS count.
.def	TEMP3		=R18	;
.def	TEMP4		=R19	;These two temps are used solely by ISRs so they don't
.def	TEMP5		=R20	;have to push and pop so much.

.def	TEMP6		=R21	;
.def	Temp_BITFLAGS	=R22	;Momentary storage for a task's bitflags.

.def	TTEMP		=R23	;ISR Temp registers
.def	TTEMP2		=R24	;
.def	TTEMP3		=R25	;
;
.def	XL		=R26	;These are used by the buffer managers, they're
.def	XH		=R27	;mostly listed here so I don't forget
.def	YL		=R28	;	
.def	YH		=R29	;
.def	ZL		=R30	;
.def	ZH		=R31	;
;
;R26,27 R28,29 and R30,31 are pointers
;********************************************************************
;
;Ram buffers
;Everything after this resides in specified locations in RAM.
;
;.org 0x60	;The beginning of RAM (Since we are in a DSEG)
;
.CSEG	;DON'T REMOVE THIS!  We need to tell the assembler that code follows.
;
