;***************************************************************************
; 
; File Name		:'EEPROM.asm"
; Title			:
; Date			:
; Version		:
; Support telephone	:765 287 1987  David B. VanHorn
; Support fax		:765 287 1989
; Support Email		:dvanhorn@cedar.net
; Support Snail		;1104 E 13th St, Muncie IN 47302
; Target MCU		:AT90S8515
; 
;***************************************************************************;
;	D E S C R I P T I O N
;
;Example code for using the onboard EEPROM including safe read and write
;
;***************************************************************************;
;	M O D I F I C A T I O N   H I S T O R Y 
;
;
;       rev.      date    who   why
;	----	--------  ---	------------------------------------------
;	0.01	98.11.30  dvh	Creation
;	0.02	99.10.21  dvh	Just goes to show you how long a simple
;				bug can go undetected. I was setting the
;				wrong bits in previous versions!
;				(Don't you guys TEST this stuff?? :)
;				Updated to use the bit names, and added 
;				readback verification on write
;	0.03	00.10.10 dvh	Found a bug in the ICE200 WRT the EEPROM flags
;				Made things a little clearer.
;
;********************************************************************
;
.dseg
EEPROM_Timer:	.byte	1	;Used for timeout on waiting for writes to complete
.cseg
.equ	Max_EE_Wait =	5	;mS before we give up waiting for a write to complete
				;You could set this smaller, but watch out.
.equ	EE_Pattern = $AAh	;
			
;          00000000011111111112222222222333
;          12345678901234567890123456789012
EE_Blown:
.db       "EEPROM BLOWN!!!  Version FOUR.0 ",0

;********************************************************************
;Init EEPROM to all AAh
;********************************************************************

EE_Pave:
	ldi	XL,$00			;EEPROM address
	ldi	XH,$00			;
	ldi	TEMP,EE_Pattern		;Data
	
EE_Pave_Loop:
	rcall	Save_EE			;Write it to EEPROM
					;Incs X, so it's ready to go for
					;sequential operations
					;Sets Carry flag if problems

	brcc	EE_Pave_Again		;If succesful, the do the next.
	nop				;Otherwise at least a breakpoint

	ldi	ZL,low(EE_Blown*2)	;Make the Z reg point at the table
	ldi	ZH,high(EE_Blown*2)	;preparing for the LPM instruction
	rcall	VFD_STR_OUT		;String to buf, buf to VFD

	rcall	Check_VFD_Display 	;


EE_Pave_Again:
	cpi	XH,$02			;If XH=02, the XL has to be 00
	brne	EE_Pave_Loop		;
	ret
	
;********************************************************************
;Here, we take each setting from SRAM or Registers, and put them into
;EEPROM for safekeeping
;********************************************************************

Check_EE:
	;Read a randomized location
	mov	XL,RAND1		;Get a random pointer
	mov	XH,RAND2		;
	andi	XH,$FE			;Keep it in range
	
	rcall	Read_EE			;Write it to EEPROM
					;Incs X, so it's ready to go for
					;sequential operations
					;Sets Carry flag if problems
	cpi	TEMP,EE_Pattern		;
	breq	EE_Test_Done		;
	
	;If not what should be there:

	ldi	ZL,low(EE_Blown*2)	;Make the Z reg point at the table
	ldi	ZH,high(EE_Blown*2)	;preparing for the LPM instruction
	rcall	VFD_STR_OUT		;String to buf, buf to VFD
	rcall	Check_VFD_Display 	;
	
EE_Test_Done:
	;Dummy


;********************************************************************
;Here, we take each setting from SRAM or Registers, and put them into
;EEPROM for safekeeping
;********************************************************************
;
Save_Settings:

	push	TEMP			;
	push	TEMP2			;

	ldi	XL,$01			;Pointing to the lowest cell
	ldi	XH,$00			;+1 (Don't use 00)
	
	;Just an example here, saving the settings of some
	;digital pots stored in ram, using the auto-increment 
	;feature of the Read_EE and Save_EE routines
	;
	;Save pot setting
	;lds	TEMP,POT1		;	
	;rcall	Save_EE			;
	;lds	TEMP,POT2		;		
	;rcall	Save_EE			;
	;lds	TEMP,POT3		;		
	;rcall	Save_EE			;
	;lds	TEMP,POT4		;		
	;rcall	Save_EE			;
	;lds	TEMP,POT5		;	
	;rcall	Save_EE			;
	;lds	TEMP,POT6		;	
	;rcall	Save_EE			;

	pop	TEMP2			;
	pop	TEMP			;

	ret
;
;********************************************************************
;Loads settings back into ram.
;********************************************************************
;
Load_Settings:

	push	TEMP			;
	push	TEMP2			;
	
	ldi	XL,$01			;Start at 0001, not 0000
	ldi	XH,$00			;Cell 0000 is a likely candidate for 
					;accidental corruption, so don't use it!

	;Recall pot settings
	;rcall	Read_EE			;Read_EE also auto-increments the address.
	;sts	POT1,TEMP		;
	;rcall	Read_EE			;
	;sts	POT2,TEMP		;
	;rcall	Read_EE			;
	;sts	POT3,TEMP		;
	;rcall	Read_EE			;
	;sts	POT4,TEMP		;
	;rcall	Read_EE			;
	;sts	POT5,TEMP		;
	;rcall	Read_EE			;
	;sts	POT6,TEMP		;

	pop	TEMP2			;
	pop	TEMP			;

	ret				;

;********************************************************************
;Put a single byte in EEPROM, safely per manual, with readback verify
;Call with pointer to EEPROM in X, data in TEMP.
;Increments X, Trashes TEMP2
;********************************************************************
;
Save_EE:

	;APPARENT EMULATOR BUG IN THE ICE200 REQUIRES THAT
	;YOU POLL FOR /EEWE AND /EERE BEFORE WRITING, AFTER A READ

	rcall	Timed_Smack		;In case the loop takes a while
	in	TEMP2,EECR		;Poll for ready
	andi	TEMP2,3			;All three bits must be zero
	brne	Save_EE			;Loop till zero

	out	EEARH,XH		;Point at the current cell
	out	EEARL,XL		;
	out	EEDR,TEMP		;Data's ready to be saved

	;WARNING: This section cannot be single-stepped in the
	;emulator due to timing constraints.
	cli				;No ints now
	sbi	EECR,2 ;EEMWE		;Set master write enable=1
	sbi	EECR,1 ;EEWE		;Set write enable to 1, starts the write
	sei				;Ok, now you can bother me.
	;End of critical section

	adiw	XL,1			;Increment the address for nest call

	;rjmp	Save_EE_Ok		;If you don't want readback, then
					;all you have to do is uncomment this line


	;Now, we have to wait for the write to complete
Save_EE_Verify:
	ldi	TEMP2,Max_EE_Wait	;Max mS to wait
	sts	EEPROM_Timer,TEMP2	;
Save_EE_V_Loop:
	rcall	Timed_Smack		;In case we wait through a WDT
	lds	TEMP2,EEPROM_Timer	;
	and	TEMP2,TEMP2		;Is it zero yet?
	breq	Save_EE_Bad2		;If so, then signal failure >20ms to write

	in	TEMP2,EECR		;Poll for EECR,EEWE=1 before continuing!
	andi	TEMP2,1 ;EEWE		;
	brne	Save_EE_V_Loop		;Potential to loop forever.


	;Time to read the data
	;Address is already set, so just read it back
	sbi	EECR,1 ;EERE		;Set EE Read Enable
	in	TEMP2,EEDR		;Get the data

	;If unequal, then signal failure
	cp	TEMP,TEMP2		;
	brne	Save_EE_Bad		;

	;otherwise
	clc				;Indicate success
	rjmp	Save_EE_Exit		;

	;Redundant code, but it lets me breakpoint and know which way it failed.

Save_EE_Bad:
	sec				;Data didn't match
	
Save_EE_Bad2:
	sec				;timeout on readback

Save_EE_Exit:
	ldi	TEMP2,$FF		;Point at non-existent location
	out	EEARL,TEMP2		;when not in active use.
	out	EEARH,TEMP2		;
	ret				;
;
;********************************************************************
;Gets a single byte from EEPROM, safely
;********************************************************************
;
Read_EE:
	rcall	Timed_Smack		;
	in	TEMP2,EECR		;Poll for EECR,2=0 before continuing!
	andi	TEMP2,$03		;Not sure you need ALL flags=0 but it's harmless
					;See bug description in Write_EE
	brne	Read_EE			;Potential to loop forever.

	out	EEARH,XH		;Set up the address
	out	EEARL,XL		;
	sbi	EECR,EERE		;Set EE Read Enable
	in	TEMP,EEDR		;Get the data

	;If you're REALLY paranoid, you could do a second read, and compare
	;here, as above, but if the cell stored junk, then you'll likely
	;just get the same junk twice.

	adiw	XL,1			;Inc the pointer

	ldi	TEMP2,$FF		;Point at non-existent location
	out	EEARL,TEMP2		;when not in active use.
	out	EEARH,TEMP2		;

	ret				;
;
;********************************************************************
;Here is how you tell the assembler to put data in EEPROM
;********************************************************************
;
.eseg	;Put this in EEPROM
.org	$020				;
	.db	0			;Location 0 is unused
	.db	$32			;Pot 1 t0 middle
	.db	$16			;Pot 2
	.db	$08			;and so on
	.db	$04			;
	.db	$02			;
	.db	$01			;
	.db	0			;

;Make sure to stop before the beginning of the program memory
.cseg	;Back to code

