;***************************************************************************
; 
; File Name		:'EEPOT.asm"
; Title			:
; Date			:
; Version		:
; Support telephone	:765 287 1987  David B. VanHorn
; Support fax		:765 287 1989
; Support Email		:dvanhorn@cedar.net
; Support Snail		;1104 E 13th St, Muncie IN 47302
; Target MCU		:AT90S8515
; 
;***************************************************************************;
;	D E S C R I P T I O N
;
;	Handler for DS1806 Sextet pot.
;
;***************************************************************************;
;	M O D I F I C A T I O N   H I S T O R Y 
;
;
;       rev.      date    who   why
;	----	--------  ---	------------------------------------------
;	0.01	98.11.06  dvh	Creation
;
;	This was originally coded as a mixer, using a Dallas sextet pot.
;	There was an LCD display, which had a bargraph when the pot was
;	being altered.
;
;********************************************************************
;
.equ	POT_Port=PORTA		;
.equ	POT_RST=6		;High when talking to pots. Low, when not
.equ	POT_CK=5		;Toggle high when data is valid
.equ	POT_Data=4		;Put the data here.. Duh!

;POT1	Line in Left Level
;POT2	Line in Right Level
;POT3	Line in Balance Left
;POT4	Line in Balance Right
;POT5	Mic in level
;POT6	LCD Contrast
;
;

;With each routine named like this, all you have to do is call it when you want
;to alter the pot by a step in a particular direction.
;
Balance_Right:
	lds	TEMP,POT3	;Get left balance
	rcall	Pot_Down	;
	sts	POT3,TEMP	;
	lds	TEMP,POT4	;Get right balance
	rcall	Pot_Up		;
	sts	POT4,TEMP	;
	rcall	Bargraph	;
	rcall	Say_LineBal	;
	rcall	Set_Pots	;Make it happen
	ret			;
;
;
;
Balance_Left:
	lds	TEMP,POT3	;Get left balance
	rcall	Pot_Up		;
	sts	POT3,TEMP	;
	lds	TEMP,POT4	;Get right balance
	rcall	Pot_Down	;
	sts	POT4,TEMP	;
	rcall	Bargraph	;
	rcall	Say_LineBal	;
	rcall	Set_Pots	;Make it happen
	ret			;
;
;
;
Line_Up:
	lds	TEMP,POT1	;Get left line level
	rcall	POT_Up		;
	sts	POT1,TEMP	;
	lds	TEMP,POT2	;Get right line level
	rcall	POT_Up		;
	sts	POT2,TEMP	;
	rcall	Bargraph	;
	rcall	Say_LineLevel	;
	rcall	Set_Pots	;Make it happen
	ret			;
;
;
;
Line_Down:
	lds	TEMP,POT1	;Get left line level
	rcall	POT_Down	;
	sts	POT1,TEMP	;
	lds	TEMP,POT2	;Get right line level
	rcall	POT_Down	;
	sts	POT2,TEMP	;
	rcall	Bargraph	;
	rcall	Say_LineLevel	;
	rcall	Set_Pots	;Make it happen
	ret			;
;
;
;
Mic_Up:
	lds	TEMP,POT5	;Get mic level
	rcall	POT_Up		;
	sts	POT5,TEMP	;
	rcall	Bargraph	;
	rcall	Say_MicLevel	;
	rcall	Set_Pots	;Make it happen
	ret			;
;
;
;
Mic_Down:
	lds	TEMP,POT5	;Get mic level
	rcall	POT_Down	;
	sts	POT5,TEMP	;
	rcall	Bargraph	;
	rcall	Say_MicLevel	;
	rcall	Set_Pots	;Make it happen
	ret			;
;
;
;
LCD_Up:
	lds	TEMP,POT6	;Get LCD level
	rcall	POT_Up		;
	sts	POT6,TEMP	;
	rcall	Bargraph	;
	rcall	Say_LCDLevel	;
	rcall	Set_Pots	;Make it happen
	ret			;
;
;
;
LCD_Down:
	lds	TEMP,POT6	;Get LCD Level
	rcall	POT_Down	;
	sts	POT6,TEMP	;
	rcall	Bargraph	;
	rcall	Say_LCDLevel	;
	rcall	Set_Pots	;Make it happen
	ret			;
;
;Bargraph code for display
;
Bargraph:
	clc			;0-64
	ror	TEMP		;0-32
	clc			;
	ror	TEMP		;Now TEMP has 0-16 How conveeeenient!

	mov	LOOP,TEMP	;Temp has the # of blocks to store
	lds	TEMP,$FF	;Use block char

	;I want to store 0-16 block chars into the LCD_OUT_BUF
Bar_Loop:
	ldi	YH,high(LCD_OUT_BUF)	;
	ldi	YL,low(LCD_OUT_BUF)	;
	ld	TEMP,Y+		;Shift the pointer 16 chars in.
	ld	TEMP,Y+		;
	ld	TEMP,Y+		;
	ld	TEMP,Y+		;
	ld	TEMP,Y+		;
	ld	TEMP,Y+		;
	ld	TEMP,Y+		;
	ld	TEMP,Y+		;
	ld	TEMP,Y+		;
	ld	TEMP,Y+		;
	ld	TEMP,Y+		;
	ld	TEMP,Y+		;
	ld	TEMP,Y+		;
	ld	TEMP,Y+		;
	ld	TEMP,Y+		;
	ld	TEMP,Y+		;
	ldi	TEMP,$FF	;
	st	Y,TEMP		;
	ld	TEMP,Y+		;
	dec	loop
	brne	Bar_Loop

	rcall	LCD_Fill	;Fill the rest with spaces

	ret

;
;Inc, unless it goes to 65, then set back to 64.
;
POT_Up:
	inc	TEMP		;
	cpi	TEMP,64		;
	brne	PU_Done		;
	ldi	TEMP,64		;
PU_Done:
	ret			;

;
;Dec, unless it wraps, then leave it at zero
;
POT_Down:
	dec	TEMP		;
	cpi	TEMP,64		;
	brlt	PD_Done		;
	ldi	TEMP,0		;
PD_Done:
	ret			;

;
;Called whenever we want something to happen on the pots.
;
Set_Pots:

	lds	TEMP,POT1	;
	ori	TEMP,$C0	;Unconditionally load
	rcall	Pot_Speak	;Send the byte

	lds	TEMP,POT2	;
	ori	TEMP,$C0	;Unconditionally load
	rcall	Pot_Speak	;

	lds	TEMP,POT3	;
	ori	TEMP,$C0	;Unconditionally load
	rcall	Pot_Speak	;

	lds	TEMP,POT4	;
	ori	TEMP,$C0	;Unconditionally load
	rcall	Pot_Speak	;

	lds	TEMP,POT5	;
	ori	TEMP,$C0	;Unconditionally load
	rcall	Pot_Speak	;

	lds	TEMP,POT6	;
	ori	TEMP,$C0	;Unconditionally load
	rcall	Pot_Speak	;

	ret
;
;Send a byte to the EEPOT
;
;Why didn't I code this as a loop? (Or the routine that calls it for that matter!)
;It's faster this way.  In a loop, you save codespace, but you have to allocate a 
;loop counter (not a huge deal) and every time you go through the loop, you have to 
;alter the loop counter, and decide wether you're done or not. 
;
;Generally, I'll straightline things like this, and later compress some of them into 
;loops if I get tight on space. 
;
Pot_Speak:

	sbi	POT_PORT,POT_RST	;Take it out of reset
	ror	TEMP			;Shift the bit to send into carry
	rcall	Pot_Bit			;Send that bit
	ror	TEMP			;
	rcall	Pot_Bit			;Again
	ror	TEMP			;
	rcall	Pot_Bit			;Again
	ror	TEMP			;
	rcall	Pot_Bit			;Again
	ror	TEMP			;
	rcall	Pot_Bit			;Again
	ror	TEMP			;
	rcall	Pot_Bit			;Again
	ror	TEMP			;
	rcall	Pot_Bit			;Again
	ror	TEMP			;
	rcall	Pot_Bit			;Again.
	ret
;
;Send a single bit
;Depends on the carry flag from pot_speak, to decide wether
;to send a one, or a zero.
;
Pot_Bit:
	brcc	POT_Zero		;
Pot_One:
	sbi	POT_Port,Pot_Data	;
	rjmp	Pot_Clk			;
Pot_Zero:
	cbi	POT_Port,Pot_Data	;
Pot_Clk:
	sbi	POT_PORT,POT_CK		;
	cbi	POT_PORT,POT_CK		;
	ret
